/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain;

import org.gradle.api.Incubating;
import org.gradle.jvm.toolchain.internal.DefaultJavaLanguageVersion;

public interface JavaLanguageVersion
extends Comparable<JavaLanguageVersion> {
    public static JavaLanguageVersion of(int version) {
        return DefaultJavaLanguageVersion.of(version);
    }

    public static JavaLanguageVersion of(String version) {
        try {
            return JavaLanguageVersion.of(Integer.parseInt(version));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("JavaLanguageVersion must be a positive integer, not '" + version + "'");
        }
    }

    @Incubating
    public static JavaLanguageVersion current() {
        return DefaultJavaLanguageVersion.fromFullVersion(System.getProperty("java.version"));
    }

    public int asInt();

    public String toString();

    public boolean canCompileOrRun(JavaLanguageVersion var1);

    public boolean canCompileOrRun(int var1);
}

