/*
 * Decompiled with CFR 0.152.
 */
package jspecview.source;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Vector;
import javajs.util.PT;
import jspecview.source.JDXSource;
import jspecview.source.XMLReader;

class CMLReader
extends XMLReader {
    private boolean specfound = false;
    String Ydelim = "";
    Vector<double[]> peakData;

    @Override
    protected JDXSource getXML(BufferedReader bufferedReader) {
        block5: {
            this.source = new JDXSource(0, this.filePath);
            this.getSimpleXmlReader(bufferedReader);
            this.processXML(4, 10);
            if (this.checkPointCount()) break block5;
            return null;
        }
        try {
            this.populateVariables();
        }
        catch (Exception exception) {
            System.err.println("Error: " + exception);
        }
        this.processErrors("CML");
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.source;
    }

    @Override
    protected boolean processTag(int n) throws Exception {
        switch (n) {
            case 4: {
                this.processSpectrum();
                return false;
            }
            case 9: {
                this.processSpectrumData();
                return true;
            }
            case 10: {
                this.processPeaks();
                return false;
            }
            case 8: {
                this.processSample();
                return true;
            }
            case 5: {
                this.processMetadataList();
                return true;
            }
            case 6: {
                this.processConditionList();
                return true;
            }
            case 7: {
                this.processParameterList();
                return true;
            }
            case 12: {
                this.processPeakList();
                return true;
            }
        }
        System.out.println("CMLSource not processing tag " + tagNames[n]);
        return false;
    }

    @Override
    protected void processEndTag(int n) throws Exception {
    }

    private void processSpectrum() throws Exception {
        if (this.attrList.contains("title")) {
            this.title = this.parser.getAttrValue("title");
        } else if (this.attrList.contains("id")) {
            this.title = this.parser.getAttrValue("id");
        }
        if (this.attrList.contains("type")) {
            this.techname = String.valueOf(this.parser.getAttrValue("type").toUpperCase()) + " SPECTRUM";
        }
    }

    private void processMetadataList() throws Exception {
        if (this.tagName.equals("metadata")) {
            this.tagName = this.parser.getAttrValueLC("name");
            if (this.tagName.contains(":origin")) {
                this.origin = this.attrList.contains("content") ? this.parser.getAttrValue("content") : this.parser.thisValue();
            } else if (this.tagName.contains(":owner")) {
                this.owner = this.attrList.contains("content") ? this.parser.getAttrValue("content") : this.parser.thisValue();
            } else if (this.tagName.contains("observenucleus")) {
                this.obNucleus = this.attrList.contains("content") ? this.parser.getAttrValue("content") : this.parser.thisValue();
            }
        }
    }

    private void processParameterList() throws Exception {
        if (this.tagName.equals("parameter")) {
            String string = this.parser.getAttrValueLC("title");
            if (string.equals("nmr.observe frequency")) {
                this.strObFreq = this.parser.qualifiedValue();
                this.obFreq = Double.parseDouble(this.strObFreq);
            } else if (string.equals("nmr.observe nucleus")) {
                this.obNucleus = this.parser.getAttrValue("value");
            } else if (string.equals("spectrometer/data system")) {
                this.modelType = this.parser.getAttrValue("value");
            } else if (string.equals("resolution")) {
                this.resolution = this.parser.qualifiedValue();
            }
        }
    }

    private void processConditionList() throws Exception {
        String string;
        if (this.tagName.equals("scalar") && (string = this.parser.getAttrValueLC("dictRef")).contains(":field")) {
            this.strObFreq = this.parser.thisValue();
            if (this.strObFreq.charAt(0) > '/' && this.strObFreq.charAt(0) < ':') {
                this.obFreq = Double.parseDouble(this.strObFreq);
            }
        }
    }

    private void processSample() throws Exception {
        if (this.tagName.equals("formula")) {
            if (this.attrList.contains("concise")) {
                this.molForm = this.parser.getAttrValue("concise");
            } else if (this.attrList.contains("inline")) {
                this.molForm = this.parser.getAttrValue("inline");
            }
        } else if (this.tagName.equals("name")) {
            this.casName = this.parser.thisValue();
        }
    }

    private void processSpectrumData() throws Exception {
        if (this.tagName.equals("xaxis")) {
            if (this.attrList.contains("multipliertodata")) {
                this.xFactor = Double.parseDouble(this.parser.getAttrValue("multiplierToData"));
            }
            this.parser.nextTag();
            this.tagName = this.parser.getTagName();
            this.attrList = this.parser.getAttributeList();
            if (this.tagName.equals("array")) {
                this.xUnits = CMLReader.checkUnits(this.parser.getAttrValue("units"));
                this.npoints = Integer.parseInt(this.parser.getAttrValue("size"));
                this.xaxisData = new double[this.npoints];
                if (this.attrList.contains("start")) {
                    this.firstX = Double.parseDouble(this.parser.getAttrValue("start"));
                    this.lastX = Double.parseDouble(this.parser.getAttrValue("end"));
                    this.deltaX = (this.lastX - this.firstX) / (double)(this.npoints - 1);
                    this.increasing = this.deltaX > 0.0;
                    this.continuous = true;
                    int n = 0;
                    while (n < this.npoints) {
                        this.xaxisData[n] = this.firstX + this.deltaX * (double)n;
                        ++n;
                    }
                } else {
                    int n = 0;
                    int n2 = -1;
                    String string = "";
                    this.Ydelim = " ";
                    this.attrList = this.parser.getCharacters().replace('\n', ' ').replace('\r', ' ').trim();
                    do {
                        n = this.attrList.indexOf(this.Ydelim);
                        string = this.attrList.substring(0, n);
                        this.xaxisData[++n2] = Double.parseDouble(string) * this.xFactor;
                        this.attrList = this.attrList.substring(n + 1, this.attrList.length()).trim();
                        n = this.attrList.indexOf(this.Ydelim);
                        while (n > 0) {
                            string = this.attrList.substring(0, n);
                            this.xaxisData[++n2] = Double.parseDouble(string) * this.xFactor;
                            this.attrList = this.attrList.substring(n + 1, this.attrList.length()).trim();
                            n = this.attrList.indexOf(this.Ydelim);
                        }
                        if (n2 >= this.npoints - 1) continue;
                        this.xaxisData[++n2] = Double.parseDouble(this.attrList) * this.xFactor;
                    } while (n2 < this.npoints - 1);
                    this.firstX = this.xaxisData[0];
                    this.lastX = this.xaxisData[this.npoints - 1];
                    this.continuous = true;
                }
            }
        } else if (this.tagName.equals("yaxis")) {
            if (this.attrList.contains("multipliertodata")) {
                this.yFactor = Double.parseDouble(this.parser.getAttrValue("multiplierToData"));
            }
            this.parser.nextTag();
            this.tagName = this.parser.getTagName();
            this.attrList = this.parser.getAttributeList();
            if (this.tagName.equals("array")) {
                this.yUnits = CMLReader.checkUnits(this.parser.getAttrValue("units"));
                Integer n = Integer.valueOf(this.parser.getAttrValue("size"));
                if (this.npoints != n) {
                    System.err.println("npoints variation between X and Y arrays");
                }
                this.yaxisData = new double[this.npoints];
                this.Ydelim = this.parser.getAttrValue("delimeter");
                if (this.Ydelim.equals("")) {
                    this.Ydelim = " ";
                }
                int n3 = 0;
                int n4 = -1;
                String string = "";
                this.attrList = this.parser.getCharacters().replace('\n', ' ').replace('\r', ' ').trim();
                do {
                    n3 = this.attrList.indexOf(this.Ydelim);
                    string = this.attrList.substring(0, n3);
                    this.yaxisData[++n4] = Double.parseDouble(string) * this.yFactor;
                    this.attrList = this.attrList.substring(n3 + 1, this.attrList.length()).trim();
                    n3 = this.attrList.indexOf(this.Ydelim);
                    while (n3 > 0) {
                        string = this.attrList.substring(0, n3);
                        this.yaxisData[++n4] = Double.parseDouble(string) * this.yFactor;
                        this.attrList = this.attrList.substring(n3 + 1, this.attrList.length()).trim();
                        n3 = this.attrList.indexOf(this.Ydelim);
                    }
                    if (n4 >= this.npoints - 1) continue;
                    this.yaxisData[++n4] = Double.parseDouble(this.attrList) * this.yFactor;
                } while (n4 < this.npoints - 1);
            }
            this.firstY = this.yaxisData[0];
            this.specfound = true;
        }
    }

    private void processPeaks() throws Exception {
        if (this.specfound) {
            return;
        }
        this.peakData = new Vector();
        this.process(12, true);
        this.npoints = this.peakData.size();
        this.xaxisData = new double[this.npoints];
        this.yaxisData = new double[this.npoints];
        int n = 0;
        while (n < this.npoints) {
            double[] dArray = this.peakData.get(n);
            this.xaxisData[n] = dArray[0];
            this.yaxisData[n] = dArray[1];
            ++n;
        }
        this.peakData = null;
        this.firstX = this.xaxisData[0];
        this.lastX = this.xaxisData[this.npoints - 1];
        this.firstY = this.yaxisData[0];
        this.increasing = this.lastX > this.firstX;
        this.continuous = false;
    }

    void processPeakList() {
        if (this.tagName.equals("peak") && this.attrList.contains("xvalue")) {
            double[] dArray = new double[2];
            dArray[1] = 50.0;
            dArray[0] = Double.parseDouble(this.parser.getAttrValue("xValue"));
            if (this.attrList.contains("xunits")) {
                this.xUnits = CMLReader.checkUnits(this.parser.getAttrValue("xUnits"));
            }
            if (this.attrList.contains("yvalue")) {
                dArray[1] = Double.parseDouble(this.parser.getAttrValue("yValue"));
            }
            if (this.attrList.contains("yunits")) {
                this.yUnits = CMLReader.checkUnits(this.parser.getAttrValue("yUnits"));
            }
            if (this.attrList.contains("atomrefs")) {
                dArray[1] = 49 * PT.getTokens(this.parser.getAttrValue("atomRefs")).length;
            }
            this.peakData.add(dArray);
        }
    }

    private static String checkUnits(String string) {
        return (string = string.substring(string.indexOf(":") + 1).toUpperCase()).equals("RELABUNDANCE") ? "RELATIVE ABUNDANCE" : (string.contains("ARBITRARY") ? "ARBITRARY UNITS" : (string.equals("MOVERZ") ? "M/Z" : (string.equals("CM-1") ? "1/CM" : (string.equals("NM") ? "NANOMETERS" : string))));
    }
}

