/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.util.Objects;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.spi.NavigablePath;

public class SqmAliasedNodeRef
extends AbstractSqmExpression<Integer> {
    private final int position;
    private final NavigablePath navigablePath;

    public SqmAliasedNodeRef(int position, SqmBindableType<Integer> intType, NodeBuilder criteriaBuilder) {
        super(intType, criteriaBuilder);
        this.position = position;
        this.navigablePath = null;
    }

    public SqmAliasedNodeRef(int position, NavigablePath navigablePath, SqmBindableType<Integer> type, NodeBuilder criteriaBuilder) {
        super(type, criteriaBuilder);
        this.position = position;
        this.navigablePath = navigablePath;
    }

    private SqmAliasedNodeRef(SqmAliasedNodeRef original) {
        super(original.getNodeType(), original.nodeBuilder());
        this.position = original.position;
        this.navigablePath = original.navigablePath;
    }

    @Override
    public SqmAliasedNodeRef copy(SqmCopyContext context) {
        SqmAliasedNodeRef existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmAliasedNodeRef expression = context.registerCopy(this, new SqmAliasedNodeRef(this));
        this.copyTo(expression, context);
        return expression;
    }

    public int getPosition() {
        return this.position;
    }

    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        if (this.navigablePath == null) {
            hql.append(this.position);
        } else {
            hql.append(this.navigablePath.getLocalName());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof SqmAliasedNodeRef)) return false;
        SqmAliasedNodeRef that = (SqmAliasedNodeRef)object;
        if (this.position != that.position) return false;
        if (!Objects.equals(this.navigablePath == null ? null : this.navigablePath.getLocalName(), that.navigablePath == null ? null : that.navigablePath.getLocalName())) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.position, this.navigablePath == null ? null : this.navigablePath.getLocalName());
    }
}

