/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ngrams;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.FakeLanguage;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.ngrams.ConfusionProbabilityRule;
import org.languagetool.rules.ngrams.FakeLanguageModel;

public class ConfusionProbabilityRuleTest {
    private final ConfusionProbabilityRule rule = new FakeRule((LanguageModel)new FakeLanguageModel(), new FakeLanguage());
    private final JLanguageTool lt = new JLanguageTool((Language)new FakeLanguage());

    @Test
    public void testRule() throws IOException {
        this.assertGood("Their");
        this.assertGood("There");
        this.assertMatch("Their are new ideas to explore.");
        this.assertGood("There are new ideas to explore.");
        this.assertMatch("Why is there car broken again?");
        this.assertGood("Why is their car broken again?");
        this.assertGood("Is this their useful test?");
        this.assertGood("Is this there useful test?");
        FakeRule ruleWithException = new FakeRule((LanguageModel)new FakeLanguageModel(), new FakeLanguage()){

            protected boolean isException(String sentenceText, int startPos, int endPos) {
                return sentenceText.contains("Their are");
            }
        };
        this.assertGood("Their are new ideas to explore.", (Rule)ruleWithException);
        this.assertGood("\"Their are new ideas to explore.\"", (Rule)ruleWithException);
        this.assertGood("But \u0130m dabei gut auszusehen.");
    }

    @Test
    public void testLocalException() throws IOException {
        FakeRule rule1 = new FakeRule((LanguageModel)new FakeLanguageModel(), new FakeLanguage()){};
        this.assertMatch("Their are new ideas to explore.", (Rule)rule1);
        FakeRule rule2 = new FakeRule((LanguageModel)new FakeLanguageModel(), new FakeLanguage(), Arrays.asList("their are")){};
        this.assertGood("Their are new ideas to explore.", (Rule)rule2);
        this.assertGood("And their are new ideas to explore.", (Rule)rule2);
        this.assertGood("Their are new ideas to explore and their are new plans.", (Rule)rule2);
    }

    private void assertMatch(String input, Rule rule) throws IOException {
        RuleMatch[] matches = rule.match(this.lt.getAnalyzedSentence(input));
        Assert.assertThat((String)("Did not find match in: " + input), (Object)matches.length, (Matcher)Is.is((Object)1));
    }

    private void assertMatch(String input) throws IOException {
        this.assertMatch(input, (Rule)this.rule);
    }

    private void assertGood(String input, Rule rule) throws IOException {
        RuleMatch[] matches = rule.match(this.lt.getAnalyzedSentence(input));
        Assert.assertThat((String)("Got unexpected match in: " + input), (Object)matches.length, (Matcher)Is.is((Object)0));
    }

    private void assertGood(String input) throws IOException {
        this.assertGood(input, (Rule)this.rule);
    }

    private static class FakeRule
    extends ConfusionProbabilityRule {
        private FakeRule(LanguageModel languageModel, Language language) {
            super(JLanguageTool.getMessageBundle(), languageModel, language);
        }

        private FakeRule(LanguageModel languageModel, Language language, List<String> exceptions) {
            super(JLanguageTool.getMessageBundle(), languageModel, language, 3, exceptions);
        }

        public String getDescription() {
            return null;
        }
    }
}

