/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.Nullable;
import org.languagetool.Language;
import org.languagetool.chunking.ChunkTag;
import org.languagetool.rules.CorrectExample;
import org.languagetool.rules.ErrorTriggeringExample;
import org.languagetool.rules.IncorrectExample;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.Match;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.RegexPatternRule;
import org.languagetool.rules.patterns.RegexRuleFilter;
import org.languagetool.rules.patterns.RegexRuleFilterCreator;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.rules.patterns.RuleFilterCreator;
import org.languagetool.rules.patterns.StringMatcher;
import org.languagetool.rules.patterns.UnifierConfiguration;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;
import org.languagetool.tools.StringInterner;
import org.languagetool.tools.StringTools;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLRuleHandler
extends DefaultHandler {
    public static final String ID = "id";
    public static final String NAME = "name";
    protected static final String PREMIUM = "premium";
    protected static final String YES = "yes";
    protected static final String OFF = "off";
    protected static final String GOAL_SPECIFIC = "is_goal_specific";
    protected static final String TRUE = "true";
    protected static final String FALSE = "false";
    protected static final String TEMP_OFF = "temp_off";
    protected static final String ON = "on";
    protected static final String POSTAG = "postag";
    protected static final String CHUNKTAG = "chunk";
    protected static final String CHUNKTAG_REGEXP = "chunk_re";
    protected static final String POSTAG_REGEXP = "postag_regexp";
    protected static final String REGEXP = "regexp";
    protected static final String NEGATE = "negate";
    protected static final String INFLECTED = "inflected";
    protected static final String NEGATE_POS = "negate_pos";
    protected static final String MARKER = "marker";
    protected static final String DEFAULT = "default";
    protected static final String TYPE = "type";
    protected static final String SPACEBEFORE = "spacebefore";
    protected static final String EXAMPLE = "example";
    protected static final String SCOPE = "scope";
    protected static final String IGNORE = "ignore";
    protected static final String SKIP = "skip";
    protected static final String MIN = "min";
    protected static final String MAX = "max";
    protected static final String TOKEN = "token";
    protected static final String FEATURE = "feature";
    protected static final String UNIFY = "unify";
    protected static final String UNIFY_IGNORE = "unify-ignore";
    protected static final String AND = "and";
    protected static final String OR = "or";
    protected static final String EXCEPTION = "exception";
    protected static final String CASE_SENSITIVE = "case_sensitive";
    protected static final String MARK = "mark";
    protected static final String PATTERN = "pattern";
    protected static final String ANTIPATTERN = "antipattern";
    protected static final String MATCH = "match";
    protected static final String UNIFICATION = "unification";
    protected static final String RULE = "rule";
    protected static final String RULES = "rules";
    protected static final String RULEGROUP = "rulegroup";
    protected static final String NO = "no";
    protected static final String PHRASES = "phrases";
    protected static final String MESSAGE = "message";
    protected static final String SUGGESTION = "suggestion";
    protected static final String TABNAME = "tab";
    protected static final String MINPREVMATCHES = "min_prev_matches";
    protected static final String DISTANCETOKENS = "distance_tokens";
    protected static final String PRIO = "prio";
    protected List<AbstractPatternRule> rules = new ArrayList<AbstractPatternRule>();
    protected Language language;
    protected ResourceBundle messages;
    protected StringBuilder correctExample = new StringBuilder();
    protected StringBuilder antiPatternExample = new StringBuilder();
    protected StringBuilder antiPatternForRuleGroupExample = new StringBuilder();
    protected StringBuilder incorrectExample = new StringBuilder();
    protected StringBuilder errorTriggerExample = new StringBuilder();
    protected StringBuilder exampleCorrection = null;
    protected StringBuilder message = new StringBuilder();
    protected StringBuilder suggestionsOutMsg = new StringBuilder();
    protected StringBuilder match = new StringBuilder();
    protected StringBuilder elements;
    protected StringBuilder exceptions;
    protected List<CorrectExample> correctExamples = new ArrayList<CorrectExample>();
    protected List<CorrectExample> antipatternExamples = new ArrayList<CorrectExample>();
    protected List<CorrectExample> antipatternForRuleGroupsExamples = new ArrayList<CorrectExample>();
    protected List<IncorrectExample> incorrectExamples = new ArrayList<IncorrectExample>();
    protected List<ErrorTriggeringExample> errorTriggeringExamples = new ArrayList<ErrorTriggeringExample>();
    protected boolean inPattern;
    protected boolean inCorrectExample;
    protected boolean inIncorrectExample;
    protected boolean inErrorTriggerExample;
    protected boolean inAntiPatternExample;
    protected boolean inAntiPatternForRuleGroupExample;
    protected boolean inMessage;
    protected boolean inSuggestion;
    protected boolean inMatch;
    protected boolean inRuleGroup;
    protected boolean inToken;
    protected boolean inException;
    protected boolean inPhrases;
    protected boolean inAndGroup;
    protected boolean inOrGroup;
    protected boolean tokenSpaceBefore;
    protected boolean tokenSpaceBeforeSet;
    protected String posToken;
    protected ChunkTag chunkTag;
    protected boolean posNegation;
    protected boolean posRegExp;
    protected boolean caseSensitive;
    protected boolean regExpression;
    protected boolean tokenNegated;
    protected boolean tokenInflected;
    protected String premiumRuleGroupAttribute;
    protected String premiumCategoryAttribute;
    protected String premiumFileAttribute;
    protected boolean isPremiumRule;
    protected List<String> categoryTags = new ArrayList<String>();
    protected List<String> ruleGroupTags = new ArrayList<String>();
    protected List<String> ruleGroupToneTags = new ArrayList<String>();
    protected List<String> categoryToneTags = new ArrayList<String>();
    protected List<String> ruleTags = new ArrayList<String>();
    protected List<String> ruleToneTags = new ArrayList<String>();
    protected String isGoalSpecificCategoryAttribute;
    protected String isGoalSpecificRuleGroupAttribute;
    protected boolean isGoalSpecific;
    protected int prioCategoryAttribute;
    protected int prioRuleGroupAttribute;
    protected int prioRuleAttribute;
    protected boolean tokenLevelCaseSensitive;
    protected boolean tokenLevelCaseSet;
    protected String exceptionPosToken;
    protected boolean exceptionStringRegExp;
    protected boolean exceptionStringNegation;
    protected boolean exceptionStringInflected;
    protected boolean exceptionPosNegation;
    protected boolean exceptionPosRegExp;
    protected boolean exceptionValidNext;
    protected boolean exceptionValidPrev;
    protected boolean exceptionSet;
    protected boolean exceptionSpaceBefore;
    protected boolean exceptionSpaceBeforeSet;
    protected Boolean exceptionLevelCaseSensitive;
    protected boolean exceptionLevelCaseSet;
    protected List<PatternToken> patternTokens = new ArrayList<PatternToken>();
    protected boolean lastPhrase;
    protected String phraseIdRef;
    protected String phraseId;
    protected int skipPos;
    protected int minOccurrence = 1;
    protected int maxOccurrence = 1;
    protected String ruleGroupId;
    protected String id;
    protected PatternToken patternToken;
    protected Match tokenReference;
    protected List<Match> suggestionMatches = new ArrayList<Match>();
    protected List<Match> suggestionMatchesOutMsg = new ArrayList<Match>();
    protected Locator pLocator;
    protected int xmlLineNumber = -1;
    protected int xmlLineNumberAntiPattern = -1;
    protected int startPositionCorrection;
    protected int endPositionCorrection;
    protected int tokenCounter;
    protected Map<String, List<List<PatternToken>>> phraseMap;
    protected List<ArrayList<PatternToken>> phrasePatternTokens = new ArrayList<ArrayList<PatternToken>>();
    protected int andGroupCounter;
    protected int orGroupCounter;
    protected boolean inUrl;
    protected boolean inUrlForRuleGroup;
    protected StringBuilder url = new StringBuilder();
    protected StringBuilder urlForRuleGroup = new StringBuilder();
    protected boolean inRegex;
    protected StringBuilder regex = new StringBuilder();
    protected RegexpMode regexMode = RegexpMode.SMART;
    protected boolean regexCaseSensitive = false;
    protected int regexpMark = 0;
    protected boolean inShortMessage;
    protected boolean inShortMessageForRuleGroup;
    protected StringBuilder shortMessage = new StringBuilder();
    protected StringBuilder shortMessageForRuleGroup = new StringBuilder();
    protected boolean inUnification;
    protected boolean inMarker;
    protected boolean inUnificationDef;
    protected boolean uniNegation;
    protected boolean inUnificationNeutral;
    protected String uFeature;
    protected String uType = "";
    protected List<String> uTypeList = new ArrayList<String>();
    protected Map<String, List<String>> equivalenceFeatures = new HashMap<String, List<String>>();
    private final Map<Triple<String, Boolean, Boolean>, StringMatcher> internedMatchers = new HashMap<Triple<String, Boolean, Boolean>, StringMatcher>();
    private final Map<Triple<String, Boolean, Boolean>, PatternToken.PosToken> internedPos = new HashMap<Triple<String, Boolean, Boolean>, PatternToken.PosToken>();

    public List<AbstractPatternRule> getRules() {
        return this.rules;
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.pLocator = locator;
        super.setDocumentLocator(locator);
    }

    protected void resetToken() {
        this.posNegation = false;
        this.posRegExp = false;
        this.inToken = false;
        this.tokenSpaceBefore = false;
        this.tokenSpaceBeforeSet = false;
        this.resetException();
        this.exceptionSet = false;
        this.tokenReference = null;
    }

    protected void resetException() {
        this.exceptionStringNegation = false;
        this.exceptionStringInflected = false;
        this.exceptionPosNegation = false;
        this.exceptionPosRegExp = false;
        this.exceptionStringRegExp = false;
        this.exceptionValidNext = false;
        this.exceptionValidPrev = false;
        this.exceptionSpaceBefore = false;
        this.exceptionSpaceBeforeSet = false;
    }

    protected void preparePhrase(Attributes attrs) {
        this.phraseIdRef = attrs.getValue("idref");
        if (this.phraseMap.containsKey(this.phraseIdRef)) {
            for (List<PatternToken> curPhrTokens : this.phraseMap.get(this.phraseIdRef)) {
                for (PatternToken patternToken : curPhrTokens) {
                    patternToken.setPhraseName(this.phraseIdRef);
                }
                List copy = (List)ObjectUtils.clone(curPhrTokens);
                for (PatternToken patternToken : copy) {
                    patternToken.setInsideMarker(this.inMarker);
                }
                if (this.patternTokens.isEmpty()) {
                    this.phrasePatternTokens.add(new ArrayList(copy));
                    continue;
                }
                ArrayList<PatternToken> arrayList = new ArrayList<PatternToken>(this.patternTokens);
                arrayList.addAll(copy);
                this.phrasePatternTokens.add(new ArrayList<PatternToken>(arrayList));
                arrayList.clear();
            }
            this.lastPhrase = true;
        }
    }

    protected void finalizePhrase() {
        if (this.phraseMap == null) {
            this.phraseMap = new HashMap<String, List<List<PatternToken>>>();
        }
        for (PatternToken patternToken : this.patternTokens) {
            patternToken.setInsideMarker(this.inMarker);
        }
        if (this.phrasePatternTokens.isEmpty()) {
            this.phrasePatternTokens.add(new ArrayList<PatternToken>(this.patternTokens));
        } else {
            for (List list : this.phrasePatternTokens) {
                list.addAll(new ArrayList<PatternToken>(this.patternTokens));
            }
        }
        this.phraseMap.put(this.phraseId, new ArrayList<ArrayList<PatternToken>>(this.phrasePatternTokens));
        this.patternTokens.clear();
        this.phrasePatternTokens.clear();
    }

    protected void startPattern(Attributes attrs) throws SAXException {
        this.tokenCounter = 0;
        this.inPattern = true;
        this.caseSensitive = YES.equals(attrs.getValue(CASE_SENSITIVE));
    }

    protected void processElement(List<PatternToken> patternTokens) {
        int counter = 0;
        for (PatternToken pToken : patternTokens) {
            if (pToken.getPhraseName() != null && counter > 0 && pToken.isReferenceElement()) {
                int tokRef = pToken.getMatch().getTokenRef();
                pToken.getMatch().setTokenRef(tokRef + counter - 1);
                String offsetToken = pToken.getString().replace("\\" + tokRef, "\\" + (tokRef + counter - 1));
                pToken.setStringElement(offsetToken);
            }
            ++counter;
        }
    }

    protected void setMatchElement(Attributes attrs, boolean isSuppressMisspelled) throws SAXException {
        this.inMatch = true;
        this.match = new StringBuilder();
        Match.CaseConversion caseConversion = Match.CaseConversion.NONE;
        if (attrs.getValue("case_conversion") != null) {
            caseConversion = Match.CaseConversion.valueOf(attrs.getValue("case_conversion").toUpperCase(Locale.ENGLISH));
        }
        Match.IncludeRange includeRange = Match.IncludeRange.NONE;
        if (attrs.getValue("include_skipped") != null) {
            includeRange = Match.IncludeRange.valueOf(attrs.getValue("include_skipped").toUpperCase(Locale.ENGLISH));
        }
        Match mWorker = new Match(attrs.getValue(POSTAG), attrs.getValue("postag_replace"), YES.equals(attrs.getValue(POSTAG_REGEXP)), attrs.getValue("regexp_match"), attrs.getValue("regexp_replace"), caseConversion, YES.equals(attrs.getValue("setpos")), isSuppressMisspelled, includeRange);
        mWorker.setInMessageOnly(!this.inSuggestion);
        if (this.inMessage) {
            this.suggestionMatches.add(mWorker);
            this.message.append("\u0001\\");
            this.message.append(attrs.getValue(NO));
            this.checkNumber(attrs);
        } else if (this.inSuggestion) {
            this.suggestionMatchesOutMsg.add(mWorker);
            this.suggestionsOutMsg.append("\u0001\\");
            this.suggestionsOutMsg.append(attrs.getValue(NO));
            this.checkNumber(attrs);
        } else if (this.inToken && attrs.getValue(NO) != null) {
            int refNumber = Integer.parseInt(attrs.getValue(NO));
            this.checkRefNumber(refNumber);
            mWorker.setTokenRef(refNumber);
            this.tokenReference = mWorker;
            this.elements.append('\\');
            this.elements.append(refNumber);
        }
    }

    private void checkNumber(Attributes attrs) throws SAXException {
        if (StringTools.isEmpty(attrs.getValue(NO))) {
            throw new SAXException("References cannot be empty: \n Line: " + this.pLocator.getLineNumber() + ", column: " + this.pLocator.getColumnNumber() + ".");
        }
        if (Integer.parseInt(attrs.getValue(NO)) < 1 && this.regex.length() == 0) {
            throw new SAXException("References must be larger than 0: " + attrs.getValue(NO) + "\n Line: " + this.pLocator.getLineNumber() + ", column: " + this.pLocator.getColumnNumber() + ".");
        }
    }

    private void checkRefNumber(int refNumber) throws SAXException {
        if (refNumber > this.patternTokens.size()) {
            throw new SAXException("Only backward references in match elements are possible, tried to specify token " + refNumber + "\nLine: " + this.pLocator.getLineNumber() + ", column: " + this.pLocator.getColumnNumber() + ".");
        }
    }

    protected void setExceptions(Attributes attrs) {
        this.inException = true;
        this.exceptions = new StringBuilder();
        this.resetException();
        this.exceptionStringNegation = YES.equals(attrs.getValue(NEGATE));
        this.exceptionValidNext = "next".equals(attrs.getValue(SCOPE));
        this.exceptionValidPrev = "previous".equals(attrs.getValue(SCOPE));
        this.exceptionStringInflected = YES.equals(attrs.getValue(INFLECTED));
        if (attrs.getValue(POSTAG) != null) {
            this.exceptionPosToken = StringInterner.intern(attrs.getValue(POSTAG));
            this.exceptionPosRegExp = YES.equals(attrs.getValue(POSTAG_REGEXP));
            this.exceptionPosNegation = YES.equals(attrs.getValue(NEGATE_POS));
        }
        this.exceptionStringRegExp = YES.equals(attrs.getValue(REGEXP));
        if (attrs.getValue(SPACEBEFORE) != null) {
            this.exceptionSpaceBefore = YES.equals(attrs.getValue(SPACEBEFORE));
            boolean bl = this.exceptionSpaceBeforeSet = !IGNORE.equals(attrs.getValue(SPACEBEFORE));
        }
        if (attrs.getValue(CASE_SENSITIVE) != null) {
            this.exceptionLevelCaseSet = true;
            this.exceptionLevelCaseSensitive = YES.equals(attrs.getValue(CASE_SENSITIVE));
        } else {
            this.exceptionLevelCaseSet = false;
        }
    }

    protected void finalizeExceptions() {
        this.inException = false;
        if (!this.exceptionSet) {
            boolean tokenCase = this.caseSensitive;
            if (this.tokenLevelCaseSet) {
                tokenCase = this.tokenLevelCaseSensitive;
            }
            this.patternToken = new PatternToken(this.tokenInflected, this.internMatcher(this.elements.toString().trim(), this.regExpression, tokenCase));
            this.exceptionSet = true;
        }
        this.patternToken.setNegation(this.tokenNegated);
        if (!StringTools.isEmpty(this.exceptions.toString()) || this.exceptionPosToken != null) {
            if (this.hasPosixCharacterClass(this.exceptions.toString())) {
                this.exceptionLevelCaseSensitive = true;
            }
            boolean caseSensitive = this.exceptionLevelCaseSensitive == null ? this.patternToken.isCaseSensitive() : this.exceptionLevelCaseSensitive.booleanValue();
            PatternToken exception = new PatternToken(this.exceptionStringInflected, this.internMatcher(this.exceptions.toString().trim(), this.exceptionStringRegExp, caseSensitive));
            exception.setNegation(this.exceptionStringNegation);
            exception.setPosToken(this.obtainPosToken(this.exceptionPosToken, this.exceptionPosRegExp, this.exceptionPosNegation));
            this.patternToken.addException(this.exceptionValidNext, this.exceptionValidPrev, exception);
            this.exceptionPosToken = null;
            this.exceptionLevelCaseSensitive = null;
        }
        if (this.exceptionSpaceBeforeSet) {
            this.patternToken.setExceptionSpaceBefore(this.exceptionSpaceBefore);
        }
        this.resetException();
    }

    private boolean hasPosixCharacterClass(String s) {
        boolean res;
        boolean bl = res = s.contains("\\p{Lu}") || s.contains("\\p{Ll}");
        if (res && s.contains("(?i")) {
            throw new RuntimeException("Contradicting regex contains both '?i' (case-insensitive) and \\p{Lu}/\\p{Ll} (case-sensitive): " + s + " in rule " + this.id);
        }
        return res;
    }

    protected void setToken(Attributes attrs) throws SAXException {
        this.inToken = true;
        if (this.lastPhrase) {
            this.patternTokens.clear();
        }
        this.lastPhrase = false;
        this.tokenNegated = YES.equals(attrs.getValue(NEGATE));
        this.tokenInflected = YES.equals(attrs.getValue(INFLECTED));
        if (attrs.getValue(SKIP) != null) {
            this.skipPos = Integer.parseInt(attrs.getValue(SKIP));
        }
        if (attrs.getValue(MIN) != null) {
            this.minOccurrence = Integer.parseInt(attrs.getValue(MIN));
        }
        if (attrs.getValue(MAX) != null) {
            this.maxOccurrence = Integer.parseInt(attrs.getValue(MAX));
        }
        this.elements = new StringBuilder();
        if (attrs.getValue(POSTAG) != null) {
            this.posToken = StringInterner.intern(attrs.getValue(POSTAG));
            this.posRegExp = YES.equals(attrs.getValue(POSTAG_REGEXP));
            this.posNegation = YES.equals(attrs.getValue(NEGATE_POS));
        }
        if (attrs.getValue(CHUNKTAG) != null && attrs.getValue(CHUNKTAG_REGEXP) != null) {
            throw new SAXException("You cannot set both 'chunk' and 'chunk_re' for " + this.id);
        }
        if (attrs.getValue(CHUNKTAG) != null) {
            this.chunkTag = new ChunkTag(StringInterner.intern(attrs.getValue(CHUNKTAG)));
        } else if (attrs.getValue(CHUNKTAG_REGEXP) != null) {
            this.chunkTag = new ChunkTag(StringInterner.intern(attrs.getValue(CHUNKTAG_REGEXP)), true);
        }
        this.regExpression = YES.equals(attrs.getValue(REGEXP));
        if (attrs.getValue(SPACEBEFORE) != null) {
            this.tokenSpaceBefore = YES.equals(attrs.getValue(SPACEBEFORE));
            boolean bl = this.tokenSpaceBeforeSet = !IGNORE.equals(attrs.getValue(SPACEBEFORE));
        }
        if (!this.inAndGroup && !this.inOrGroup) {
            ++this.tokenCounter;
        }
        if (attrs.getValue(CASE_SENSITIVE) != null) {
            this.tokenLevelCaseSet = true;
            this.tokenLevelCaseSensitive = YES.equals(attrs.getValue(CASE_SENSITIVE));
        } else {
            this.tokenLevelCaseSensitive = false;
            this.tokenLevelCaseSet = false;
        }
    }

    @Nullable
    protected List<Match> addLegacyMatches(List<Match> existingSugMatches, String messageStr, boolean inMessage) {
        ArrayList<Match> sugMatch = new ArrayList<Match>();
        int pos = 0;
        int ind = 0;
        int matchCounter = 0;
        while (pos != -1) {
            pos = messageStr.indexOf(92, ind);
            if (pos != -1 && messageStr.length() > pos && Character.isDigit(messageStr.charAt(pos + 1))) {
                if (pos == 0 || messageStr.charAt(pos - 1) != '\u0001') {
                    Match mWorker = new Match(null, null, false, null, null, Match.CaseConversion.NONE, false, false, Match.IncludeRange.NONE);
                    mWorker.setInMessageOnly(true);
                    sugMatch.add(mWorker);
                } else if (messageStr.charAt(pos - 1) == '\u0001') {
                    sugMatch.add(existingSugMatches.get(matchCounter));
                    if (inMessage) {
                        this.message.deleteCharAt(pos - 1 - matchCounter);
                    } else {
                        this.suggestionsOutMsg.deleteCharAt(pos - 1 - matchCounter);
                    }
                    ++matchCounter;
                }
            }
            ind = pos + 1;
        }
        if (sugMatch.isEmpty()) {
            return existingSugMatches;
        }
        return sugMatch;
    }

    protected void finalizeTokens(UnifierConfiguration unifierConfiguration) throws SAXException {
        if (!this.exceptionSet || this.patternToken == null) {
            boolean tokenCase;
            boolean bl = tokenCase = this.caseSensitive || this.hasPosixCharacterClass(this.elements.toString());
            if (this.tokenLevelCaseSet) {
                tokenCase = this.tokenLevelCaseSensitive;
            }
            this.patternToken = new PatternToken(this.tokenInflected, this.internMatcher(this.elements.toString().trim(), this.regExpression, tokenCase));
            this.patternToken.setNegation(this.tokenNegated);
        } else {
            boolean caseSensitive = this.patternToken.isCaseSensitive() || this.hasPosixCharacterClass(this.elements.toString());
            this.patternToken.setTextMatcher(this.internMatcher(this.elements.toString().trim(), this.patternToken.isRegularExpression(), caseSensitive));
        }
        if (this.skipPos != 0) {
            this.patternToken.setSkipNext(this.skipPos);
            this.skipPos = 0;
        }
        if (this.minOccurrence == 0) {
            this.patternToken.setMinOccurrence(0);
        }
        if (this.maxOccurrence != 1) {
            this.patternToken.setMaxOccurrence(this.maxOccurrence);
            this.maxOccurrence = 1;
        }
        if (this.posToken != null) {
            this.patternToken.setPosToken(this.obtainPosToken(this.posToken, this.posRegExp, this.posNegation));
            this.posToken = null;
        }
        if (this.chunkTag != null) {
            this.patternToken.setChunkTag(this.chunkTag);
            this.chunkTag = null;
        }
        if (this.tokenReference != null) {
            this.patternToken.setMatch(this.tokenReference);
        }
        if (this.inAndGroup && this.andGroupCounter > 0) {
            this.patternTokens.get(this.patternTokens.size() - 1).setAndGroupElement(this.patternToken);
            if (this.minOccurrence != 1 || this.maxOccurrence != 1) {
                throw new SAXException("Please set min and max attributes on the first token in the AND group.\n You attempted to set these attributes on the token no. " + (this.andGroupCounter + 1) + ".\n Line: " + this.pLocator.getLineNumber() + ", column: " + this.pLocator.getColumnNumber() + ".");
            }
        } else if (this.inOrGroup && this.orGroupCounter > 0) {
            this.patternTokens.get(this.patternTokens.size() - 1).setOrGroupElement(this.patternToken);
        } else {
            if (this.minOccurrence < 1) {
                this.patternTokens.add(this.patternToken);
            }
            for (int i = 1; i <= this.minOccurrence; ++i) {
                this.patternTokens.add(this.patternToken);
            }
            this.minOccurrence = 1;
        }
        if (this.inAndGroup) {
            ++this.andGroupCounter;
        }
        if (this.inOrGroup) {
            ++this.orGroupCounter;
        }
        if (this.inUnification) {
            this.patternToken.setUnification(this.equivalenceFeatures);
        }
        if (this.inUnificationNeutral) {
            this.patternToken.setUnificationNeutral();
        }
        this.patternToken.setInsideMarker(this.inMarker);
        if (this.inUnificationDef) {
            unifierConfiguration.setEquivalence(this.uFeature, this.uType, this.patternToken);
            this.patternTokens.clear();
        }
        if (this.tokenSpaceBeforeSet) {
            this.patternToken.setWhitespaceBefore(this.tokenSpaceBefore);
        }
        this.resetToken();
    }

    private PatternToken.PosToken obtainPosToken(String posToken, boolean regExp, boolean negated) {
        return this.internedPos.computeIfAbsent((Triple<String, Boolean, Boolean>)Triple.of((Object)posToken, (Object)regExp, (Object)negated), t -> {
            StringMatcher matcher = (Boolean)t.getMiddle() != false ? this.internMatcher((String)t.getLeft(), true, true) : null;
            return new PatternToken.PosToken((String)t.getLeft(), (boolean)((Boolean)t.getRight()), matcher);
        });
    }

    protected static void setRuleFilter(String filterClassName, String filterArgs, AbstractPatternRule rule) {
        if (filterClassName != null && filterArgs != null) {
            if (rule instanceof RegexPatternRule) {
                RegexRuleFilterCreator creator = new RegexRuleFilterCreator();
                RegexRuleFilter filter = creator.getFilter(filterClassName);
                ((RegexPatternRule)rule).setRegexFilter(filter);
                rule.setFilterArguments(filterArgs);
            } else if (rule instanceof PatternRule || rule instanceof DisambiguationPatternRule) {
                RuleFilter filter = RuleFilterCreator.getInstance().getFilter(filterClassName);
                rule.setFilter(filter);
                rule.setFilterArguments(filterArgs);
            } else {
                throw new RuntimeException("Rule " + rule.getFullId() + " of type " + rule.getClass() + " cannot have a filter (" + filterClassName + ")");
            }
        }
    }

    private StringMatcher internMatcher(String text, boolean regexp, boolean caseSensitive) {
        text = StringInterner.intern(PatternToken.normalizeTextPattern(text));
        return this.internedMatchers.computeIfAbsent((Triple<String, Boolean, Boolean>)Triple.of((Object)text, (Object)regexp, (Object)caseSensitive), t -> StringMatcher.create((String)t.getLeft(), (Boolean)t.getMiddle(), (Boolean)t.getRight()));
    }

    static enum RegexpMode {
        SMART,
        EXACT;

    }
}

