/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.cert;

import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.security.pki.internal.asn1.ASN1Object;
import oracle.security.pki.internal.asn1.ASN1ObjectID;
import oracle.security.pki.internal.asn1.ASN1Set;
import oracle.security.pki.internal.asn1.ASN1SetInputStream;
import oracle.security.pki.internal.cert.Attribute;
import oracle.security.pki.util.Utils;

public class AttributeSet
implements Externalizable,
Cloneable,
ASN1Object {
    private LinkedHashMap<ASN1ObjectID, Attribute> a;
    private ASN1Set b;

    public AttributeSet() {
        this.a = new LinkedHashMap();
    }

    public AttributeSet(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public Attribute a(Attribute attribute) {
        this.e();
        return this.a.put(attribute.a(), attribute);
    }

    public Attribute a(ASN1ObjectID aSN1ObjectID, ASN1Object aSN1Object) {
        return this.a(new Attribute(aSN1ObjectID, aSN1Object));
    }

    public Attribute a(ASN1ObjectID aSN1ObjectID, List<? extends ASN1Object> list) {
        return this.a(new Attribute(aSN1ObjectID, list));
    }

    public Attribute a(ASN1ObjectID aSN1ObjectID) {
        if (this.c(aSN1ObjectID)) {
            return this.a.get(aSN1ObjectID);
        }
        return null;
    }

    public void b(ASN1ObjectID aSN1ObjectID, ASN1Object aSN1Object) {
        Attribute attribute = this.a(aSN1ObjectID);
        if (attribute != null) {
            attribute.a(aSN1Object);
        } else {
            this.a(aSN1ObjectID, aSN1Object);
        }
    }

    public ArrayList<ASN1Object> b(ASN1ObjectID aSN1ObjectID) {
        Attribute attribute = this.a(aSN1ObjectID);
        return attribute != null ? attribute.b() : null;
    }

    public Map<ASN1ObjectID, Attribute> a() {
        return this.a;
    }

    public int b() {
        return this.a.size();
    }

    public boolean c() {
        return this.a.isEmpty();
    }

    public boolean c(ASN1ObjectID aSN1ObjectID) {
        return this.a.containsKey(aSN1ObjectID);
    }

    public Object clone() {
        AttributeSet attributeSet = new AttributeSet();
        attributeSet.a = new LinkedHashMap<ASN1ObjectID, Attribute>(this.a);
        return attributeSet;
    }

    public String toString() {
        String string = "{";
        Iterator<Attribute> iterator = this.a.values().iterator();
        while (iterator.hasNext()) {
            string = string + " " + iterator.next();
            if (!iterator.hasNext()) continue;
            string = string + ",";
        }
        string = string + " }";
        return string;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.a = new LinkedHashMap();
        ASN1SetInputStream aSN1SetInputStream = new ASN1SetInputStream(inputStream);
        while (aSN1SetInputStream.a()) {
            Attribute attribute = new Attribute(aSN1SetInputStream);
            this.a.put(attribute.a(), attribute);
        }
        aSN1SetInputStream.b();
        this.e();
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.d().output(outputStream);
    }

    @Override
    public int length() {
        return this.d().length();
    }

    private void e() {
        this.b = null;
    }

    public ASN1Set d() {
        if (this.b == null) {
            ASN1Set aSN1Set = new ASN1Set();
            for (Attribute attribute : this.a.values()) {
                aSN1Set.a(attribute);
            }
            this.b = aSN1Set;
        }
        return this.b;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new IOException(classCastException);
        }
        this.input(new ByteArrayInputStream(byArray));
    }
}

