/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.metadata;

import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowDescriptorBuilder;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.jdbc.FBDatabaseMetaData;
import org.firebirdsql.jdbc.FBResultSet;
import org.firebirdsql.jdbc.metadata.AbstractMetadataMethod;
import org.firebirdsql.jdbc.metadata.Clause;
import org.firebirdsql.jdbc.metadata.DbMetadataMediator;
import org.firebirdsql.jdbc.metadata.MetadataPattern;
import org.firebirdsql.jdbc.metadata.RowValueBuilder;
import org.firebirdsql.jdbc.metadata.TypeMetadata;

public final class GetBestRowIdentifier
extends AbstractMetadataMethod {
    private static final RowDescriptor ROW_DESCRIPTOR = new RowDescriptorBuilder(8, DbMetadataMediator.datatypeCoder).at(0).simple(500, 0, "SCOPE", "ROWIDENTIFIER").addField().at(1).simple(448, 63, "COLUMN_NAME", "ROWIDENTIFIER").addField().at(2).simple(496, 0, "DATA_TYPE", "ROWIDENTIFIER").addField().at(3).simple(448, 31, "TYPE_NAME", "ROWIDENTIFIER").addField().at(4).simple(496, 0, "COLUMN_SIZE", "ROWIDENTIFIER").addField().at(5).simple(496, 0, "BUFFER_LENGTH", "ROWIDENTIFIER").addField().at(6).simple(500, 0, "DECIMAL_DIGITS", "ROWIDENTIFIER").addField().at(7).simple(500, 0, "PSEUDO_COLUMN", "ROWIDENTIFIER").addField().toRowDescriptor();
    private static final String GET_BEST_ROW_IDENT_START = "select\n  RF.RDB$FIELD_NAME as COLUMN_NAME,\n  F.RDB$FIELD_TYPE as FIELD_TYPE,\n  F.RDB$FIELD_SUB_TYPE as FIELD_SUB_TYPE,\n  F.RDB$FIELD_PRECISION as FIELD_PRECISION,\n  F.RDB$FIELD_SCALE as FIELD_SCALE,\n  F.RDB$FIELD_LENGTH as FIELD_LENGTH,\n  F.RDB$CHARACTER_LENGTH as CHAR_LEN,\n  F.RDB$CHARACTER_SET_ID as CHARSET_ID\nfrom RDB$RELATION_CONSTRAINTS RC\ninner join RDB$INDEX_SEGMENTS IDX\n  on IDX.RDB$INDEX_NAME = RC.RDB$INDEX_NAME\ninner join RDB$RELATION_FIELDS RF\n  on RF.RDB$FIELD_NAME = IDX.RDB$FIELD_NAME and RF.RDB$RELATION_NAME = RC.RDB$RELATION_NAME\ninner join RDB$FIELDS F\n  on F.RDB$FIELD_NAME = RF.RDB$FIELD_SOURCE\nwhere RC.RDB$CONSTRAINT_TYPE = 'PRIMARY KEY'\nand ";
    private static final String GET_BEST_ROW_IDENT_END = "\norder by IDX.RDB$FIELD_POSITION";

    private GetBestRowIdentifier(DbMetadataMediator mediator) {
        super(ROW_DESCRIPTOR, mediator);
    }

    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        if (table == null || "".equals(table)) {
            return this.createEmpty();
        }
        RowValueBuilder valueBuilder = new RowValueBuilder(ROW_DESCRIPTOR);
        List<RowValue> rows = this.getPrimaryKeyIdentifier(table, valueBuilder);
        if (rows.size() == 0) {
            FBDatabaseMetaData dbmd = this.mediator.getMetaData();
            RowIdLifetime rowIdLifetime = dbmd.getRowIdLifetime();
            if (rowIdLifetime == RowIdLifetime.ROWID_VALID_TRANSACTION && scope == 2) {
                return this.createEmpty();
            }
            try (ResultSet pseudoColumns = dbmd.getPseudoColumns(catalog, schema, MetadataPattern.escapeWildcards(table), "RDB$DB\\_KEY");){
                if (!pseudoColumns.next()) {
                    ResultSet resultSet = this.createEmpty();
                    return resultSet;
                }
                rows.add(valueBuilder.at(0).setShort(rowIdLifetime == RowIdLifetime.ROWID_VALID_TRANSACTION ? 1 : 2).at(1).setString("RDB$DB_KEY").at(2).setInt(-8).at(3).setString(TypeMetadata.getDataTypeName(14, 0, 1)).at(4).setInt(pseudoColumns.getInt(8)).at(5).set(null).at(6).set(null).at(7).setShort(2).toRowValue(false));
            }
        }
        return new FBResultSet(ROW_DESCRIPTOR, rows);
    }

    private List<RowValue> getPrimaryKeyIdentifier(String table, RowValueBuilder valueBuilder) throws SQLException {
        Clause tableClause = Clause.equalsClause("RC.RDB$RELATION_NAME", table);
        String sql = GET_BEST_ROW_IDENT_START + tableClause.getCondition(false) + GET_BEST_ROW_IDENT_END;
        DbMetadataMediator.MetadataQuery metadataQuery = new DbMetadataMediator.MetadataQuery(sql, Clause.parameters(tableClause));
        try (ResultSet rs = this.mediator.performMetaDataQuery(metadataQuery);){
            ArrayList<RowValue> rows = new ArrayList<RowValue>();
            while (rs.next()) {
                rows.add(this.createMetadataRow(rs, valueBuilder));
            }
            ArrayList<RowValue> arrayList = rows;
            return arrayList;
        }
    }

    @Override
    RowValue createMetadataRow(ResultSet rs, RowValueBuilder valueBuilder) throws SQLException {
        TypeMetadata typeMetadata = TypeMetadata.builder(this.mediator.getFirebirdSupportInfo()).fromCurrentRow(rs).build();
        return valueBuilder.at(0).setShort(2).at(1).setString(rs.getString("COLUMN_NAME")).at(2).setShort(typeMetadata.getJdbcType()).at(3).setString(typeMetadata.getSqlTypeName()).at(4).setInt(typeMetadata.getColumnSize()).at(5).set(null).at(6).setShort(typeMetadata.getScale()).at(7).setShort(1).toRowValue(false);
    }

    public static GetBestRowIdentifier create(DbMetadataMediator mediator) {
        return new GetBestRowIdentifier(mediator);
    }
}

