/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.repository.pdqcompare.models;

import com.ibm.db2.cmx.runtime.internal.repository.pdqcompare.models.Constants;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.tools.internal.repository.HTMLTemplateLoader;
import java.lang.reflect.Field;
import java.util.Hashtable;

public class PackageModel {
    private String collectionId = "";
    private String pkgNameRoot = "";
    private String dbPkgVersion = "";
    private String conToken = "";
    private String isBindable = "false";
    private String configStatus = "";
    private String pkgId;
    private ChangedPackageMetada chngdMetada = null;

    protected PackageModel(String string, String string2, String string3, String string4, String string5, String string6) {
        if (string != null) {
            this.collectionId = string;
        }
        if (string2 != null) {
            this.pkgNameRoot = string2;
        }
        if (string3 != null) {
            this.dbPkgVersion = string3;
        }
        if (string4 != null) {
            this.conToken = string4;
        }
        if (string5 != null) {
            this.isBindable = string5;
        }
        if (string6 != null) {
            this.configStatus = string6;
        }
        this.pkgId = this.getCollectionId() + this.getPkgNameRoot() + this.getDbPkgVersion();
    }

    protected String getPacakgeId() {
        return this.pkgId;
    }

    protected String getPacakgeChangeSectionId() {
        return this.getPacakgeId() + "_chng";
    }

    protected String getPacakgeDescriptionSectionId() {
        return this.getPacakgeId() + "_descr";
    }

    protected boolean isBindable() {
        boolean bl2;
        boolean bl3 = Boolean.valueOf(this.isBindable);
        if (this.chngdMetada != null && this.chngdMetada.isBindable != null && bl3 != (bl2 = Boolean.valueOf(this.chngdMetada.isBindable).booleanValue())) {
            bl3 = bl2;
        }
        return bl3;
    }

    public boolean isEquivalent(PackageModel packageModel) {
        boolean bl2 = this.isEquivalent(packageModel.collectionId, packageModel.pkgNameRoot, packageModel.dbPkgVersion);
        return bl2;
    }

    protected boolean isEquivalent(String string, String string2, String string3) {
        boolean bl2 = this.collectionId.equalsIgnoreCase(string) && this.pkgNameRoot.equalsIgnoreCase(string2) && this.dbPkgVersion.equalsIgnoreCase(string3);
        return bl2;
    }

    public boolean isRequireRebind(String string, String string2, String string3, String string4) {
        if (!this.isEquivalent(string, string2, string3)) {
            throw new RuntimeException("Comparing unequivalent packages for change in metadata");
        }
        boolean bl2 = !this.conToken.equalsIgnoreCase(string4);
        return bl2;
    }

    public boolean isChangedMetadata(String string, String string2, String string3, String string4, String string5, String string6) {
        boolean bl2 = !this.isRequireRebind(string, string2, string3, string4) && (!this.isBindable.equals(string5) || !this.configStatus.equals(string6));
        return bl2;
    }

    public boolean isUnchanged(String string, String string2, String string3, String string4, String string5, String string6) {
        boolean bl2 = !this.isChangedMetadata(string, string2, string3, string4, string5, string6);
        return bl2;
    }

    public String getCollectionId() {
        return this.collectionId;
    }

    public String getPkgNameRoot() {
        return this.pkgNameRoot;
    }

    public String getDbPkgVersion() {
        return this.dbPkgVersion;
    }

    protected void updateNewValues(String string, String string2, String string3, String string4, String string5) {
        if (this.chngdMetada == null) {
            this.chngdMetada = new ChangedPackageMetada();
            this.chngdMetada.collectionId = string;
            this.chngdMetada.dbPkgVersion = string2;
            this.chngdMetada.conToken = string3;
            this.chngdMetada.isBindable = string4;
            this.chngdMetada.configStatus = string5;
        }
    }

    private Field getField(Field[] fieldArray, String string) throws Exception {
        Field field = null;
        for (Field field2 : fieldArray) {
            if (!field2.getName().equalsIgnoreCase(string)) continue;
            field = field2;
            field.setAccessible(true);
            break;
        }
        return field;
    }

    protected StringBuilder printHtml(HTMLTemplateLoader hTMLTemplateLoader) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((CharSequence)this.printPackageAttrib("collectionId", "Collection", hTMLTemplateLoader));
        stringBuilder.append((CharSequence)this.printPackageAttrib("dbPkgVersion", Messages.getText("MSG_DIFFERENCE_REPORT_VERSION", new Object[0]), hTMLTemplateLoader));
        stringBuilder.append((CharSequence)this.printPackageAttrib("conToken", Messages.getText("MSG_DIFFERENCE_REPORT_CONTOKEN", new Object[0]), hTMLTemplateLoader));
        stringBuilder.append((CharSequence)this.printPackageAttrib("isBindable", Messages.getText("MSG_DIFFERENCE_REPORT_BIND", new Object[0]), hTMLTemplateLoader));
        stringBuilder.append((CharSequence)this.printPackageAttrib("configStatus", Messages.getText("MSG_DIFFERENCE_REPORT_CONFIGURE", new Object[0]), hTMLTemplateLoader));
        if (stringBuilder.length() > 0) {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            String string = Constants.getRefNameHtml(this.getPacakgeChangeSectionId(), Messages.getText("MSG_DIFFERENCE_REPORT_CHANGES", new Object[0]));
            hashtable.put("title", string);
            hashtable.put("data", stringBuilder.toString());
            stringBuilder = new StringBuilder().append(hTMLTemplateLoader.load("packageTableSubdescription", hashtable));
        }
        return stringBuilder;
    }

    private StringBuilder printPackageAttrib(String string, String string2, HTMLTemplateLoader hTMLTemplateLoader) throws Exception {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        Field field = this.getField(this.getClass().getDeclaredFields(), string);
        String string3 = (String)field.get(this);
        String string4 = null;
        boolean bl2 = false;
        if (this.chngdMetada != null) {
            object = this.getField(this.chngdMetada.getClass().getDeclaredFields(), string);
            string4 = (String)((Field)object).get(this.chngdMetada);
            boolean bl3 = bl2 = !string3.equals(string4);
            if (bl2) {
                string3 = (String)((Field)object).get(this.chngdMetada);
                string4 = (String)field.get(this);
            }
        }
        if (bl2) {
            object = new Hashtable<String, String>();
            ((Hashtable)object).put("attribute", string2);
            ((Hashtable)object).put("currval_title", Messages.getText("MSG_DIFFERENCE_REPORT_CURRVAL", new Object[0]));
            ((Hashtable)object).put("currval", string3);
            ((Hashtable)object).put("prevval_title", Messages.getText("MSG_DIFFERENCE_REPORT_PREVVAL", new Object[0]));
            ((Hashtable)object).put("prevval", string4);
            stringBuilder.append(hTMLTemplateLoader.load("packageattribchange", (Hashtable<String, String>)object));
        }
        return stringBuilder;
    }

    private class ChangedPackageMetada {
        private String collectionId = "";
        private String dbPkgVersion = "";
        private String conToken = "";
        private String isBindable = "";
        private String bindOptions = "";
        private String configStatus = "";

        private ChangedPackageMetada() {
        }
    }
}

