/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline.command;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import picocli.CommandLine;
import schemacrawler.schemacrawler.exceptions.IORuntimeException;
import us.fatehi.utility.Utility;

public final class PasswordOptions {
    @CommandLine.Option(names={"--password:env"}, description={"Database password, from an environmental variable value"}, paramLabel="<environment variable name>")
    private String passwordEnvironmentVariable;
    @CommandLine.Option(names={"--password:file"}, description={"Database password, read from a file"}, paramLabel="<path to password file>")
    private Path passwordFile;
    @CommandLine.Option(names={"--password:prompt"}, interactive=true, description={"Database password, prompted from the console"})
    private String passwordPrompted;
    @CommandLine.Option(names={"--password"}, description={"Database password"}, paramLabel="<password>")
    private String passwordProvided;

    String getPassword() {
        String password = this.getPasswordProvided();
        if (password == null) {
            password = this.getPasswordPrompted();
        }
        if (password == null) {
            password = this.getPasswordFromFile();
        }
        if (password == null) {
            password = this.getPasswordFromEnvironment();
        }
        return password;
    }

    private String getPasswordFromEnvironment() {
        if (Utility.isBlank((CharSequence)this.passwordEnvironmentVariable)) {
            return null;
        }
        String passwordEnvironment = null;
        try {
            passwordEnvironment = System.getenv(this.passwordEnvironmentVariable);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Password could not be read from environmental variable <%s>".formatted(this.passwordEnvironmentVariable), e);
        }
        return passwordEnvironment;
    }

    private String getPasswordFromFile() {
        if (this.passwordFile == null) {
            return null;
        }
        String password = null;
        try {
            List<String> lines = Files.readAllLines(this.passwordFile);
            if (!lines.isEmpty()) {
                password = lines.get(0);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException("Password could not be read from file <%s>".formatted(this.passwordFile), e);
        }
        return password;
    }

    private String getPasswordPrompted() {
        return this.passwordPrompted;
    }

    private String getPasswordProvided() {
        return this.passwordProvided;
    }
}

