/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.util;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QuerySanitizer {
    private static final String PWD_REGEX_STR = "(password)\\s*['\"].*?['\"]";
    private static final Pattern PWD_REGEX = Pattern.compile("(password)\\s*['\"].*?['\"]", 2);
    private static final String PWD_REPLACEMENT_REGEX = "$1 '***'";
    private static final String CREDS_REGEX_STR = "(\\scredentials\\s*)(as\\s*)?(?:(?:['\"].*?['\"])|.*)";
    private static final Pattern CREDS_REGEX = Pattern.compile("(\\scredentials\\s*)(as\\s*)?(?:(?:['\"].*?['\"])|.*)", 2);
    private static final String CREDS_REPLACEMENT_REGEX = "$1'***'";
    private static final String ACCESS_KEY_REGEX_STR = "(\\saccess_key_id\\s*)(as\\s*)?(?:(?:['\"].*?['\"])|.*)";
    private static final Pattern ACCESS_KEY_REGEX = Pattern.compile("(\\saccess_key_id\\s*)(as\\s*)?(?:(?:['\"].*?['\"])|.*)", 2);
    private static final String SECRET_KEY_REGEX_STR = "(\\ssecret_access_key\\s*)(as\\s*)?(?:(?:['\"].*?['\"])|.*)";
    private static final Pattern SECRET_KEY_REGEX = Pattern.compile("(\\ssecret_access_key\\s*)(as\\s*)?(?:(?:['\"].*?['\"])|.*)", 2);
    private static final String IAM_ROLE_REGEX_STR = "(\\siam_role\\s*)(as\\s*)?(?:(?:['\"].*?['\"])|.*)";
    private static final Pattern IAM_ROLE_REGEX = Pattern.compile("(\\siam_role\\s*)(as\\s*)?(?:(?:['\"].*?['\"])|.*)", 2);
    private static final String SYM_KEY_REGEX_STR = "(\\smaster_symmetric_key\\s*)(as\\s*)?(?:(?:['\"].*?['\"])|.*)";
    private static final Pattern SYM_KEY_REGEX = Pattern.compile("(\\smaster_symmetric_key\\s*)(as\\s*)?(?:(?:['\"].*?['\"])|.*)", 2);
    private static final String KMS_KEY_REGEX_STR = "(\\skms_key_id\\s*)(as\\s*)?(?:(?:['\"].*?['\"])|.*)";
    private static final Pattern KMS_KEY_REGEX = Pattern.compile("(\\skms_key_id\\s*)(as\\s*)?(?:(?:['\"].*?['\"])|.*)", 2);
    private static final String SESSION_TOKEN_REGEX_STR = "(\\ssession_token\\s*)(as\\s*)?(?:(?:['\"].*?['\"])|.*)";
    private static final Pattern SESSION_TOKEN_REGEX = Pattern.compile("(\\ssession_token\\s*)(as\\s*)?(?:(?:['\"].*?['\"])|.*)", 2);
    private static final String LINGERING_SECRET_REGEX_STR = "(((aws[-_]?)?((iam[-_]?role)|(access[-_]?key([-_]id)?)|(secret[-_]?access[-_]?key)))|(token)|((master[-_]?)?symmetric[-_]?key))\\s*=\\s*[^;'\"]*";
    private static final Pattern LINGERING_SECRET_REGEX = Pattern.compile("(((aws[-_]?)?((iam[-_]?role)|(access[-_]?key([-_]id)?)|(secret[-_]?access[-_]?key)))|(token)|((master[-_]?)?symmetric[-_]?key))\\s*=\\s*[^;'\"]*", 2);
    private static final String LINGERING_SECRET_REPLACEMENT_REGEX = "$1=***";
    private static final String ENCRYPT_KEY_REGEX_STR = "((--encryptionKey|--k|-k)\\s+)([A-Za-z0-9+/=]*)";
    private static final Pattern ENCRYPT_KEY_REGEX = Pattern.compile("((--encryptionKey|--k|-k)\\s+)([A-Za-z0-9+/=]*)", 2);
    private static final String ENCRYPT_KEY_REPLACEMENT_REGEX = "$1***";

    public static String filterCredentials(String queryText) {
        String sanitizedText = QuerySanitizer.processPassword(queryText);
        sanitizedText = QuerySanitizer.processCreds(sanitizedText);
        sanitizedText = QuerySanitizer.processAccessKey(sanitizedText);
        sanitizedText = QuerySanitizer.processSecretKey(sanitizedText);
        sanitizedText = QuerySanitizer.processIamRole(sanitizedText);
        sanitizedText = QuerySanitizer.processSymKey(sanitizedText);
        sanitizedText = QuerySanitizer.processKmsKey(sanitizedText);
        sanitizedText = QuerySanitizer.processSessionToken(sanitizedText);
        sanitizedText = QuerySanitizer.processLingeringSecrets(sanitizedText);
        sanitizedText = QuerySanitizer.processEncryptKey(sanitizedText);
        return sanitizedText;
    }

    protected static String processPassword(String queryText) {
        return QuerySanitizer.processQueryText(queryText, PWD_REGEX, PWD_REPLACEMENT_REGEX);
    }

    protected static String processCreds(String queryText) {
        return QuerySanitizer.processQueryText(queryText, CREDS_REGEX, CREDS_REPLACEMENT_REGEX);
    }

    protected static String processAccessKey(String queryText) {
        return QuerySanitizer.processQueryText(queryText, ACCESS_KEY_REGEX, CREDS_REPLACEMENT_REGEX);
    }

    protected static String processSecretKey(String queryText) {
        return QuerySanitizer.processQueryText(queryText, SECRET_KEY_REGEX, CREDS_REPLACEMENT_REGEX);
    }

    protected static String processIamRole(String queryText) {
        return QuerySanitizer.processQueryText(queryText, IAM_ROLE_REGEX, CREDS_REPLACEMENT_REGEX);
    }

    protected static String processSymKey(String queryText) {
        return QuerySanitizer.processQueryText(queryText, SYM_KEY_REGEX, CREDS_REPLACEMENT_REGEX);
    }

    protected static String processKmsKey(String queryText) {
        return QuerySanitizer.processQueryText(queryText, KMS_KEY_REGEX, CREDS_REPLACEMENT_REGEX);
    }

    protected static String processSessionToken(String queryText) {
        return QuerySanitizer.processQueryText(queryText, SESSION_TOKEN_REGEX, CREDS_REPLACEMENT_REGEX);
    }

    protected static String processLingeringSecrets(String queryText) {
        return QuerySanitizer.processQueryText(queryText, LINGERING_SECRET_REGEX, LINGERING_SECRET_REPLACEMENT_REGEX);
    }

    protected static String processEncryptKey(String queryText) {
        return QuerySanitizer.processQueryText(queryText, ENCRYPT_KEY_REGEX, ENCRYPT_KEY_REPLACEMENT_REGEX);
    }

    private static String processQueryText(String queryText, Pattern matchPattern, String replacementPattern) {
        if (Objects.isNull(queryText)) {
            return null;
        }
        Matcher matcher = matchPattern.matcher(queryText);
        return matcher.find() ? matcher.replaceAll(replacementPattern) : queryText;
    }
}

