/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.repository.metadata;

import com.ibm.db2.cmx.runtime.internal.repository.metadata.PerformanceInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SourceInfo
implements Cloneable {
    private String packageName = "";
    private String className;
    private String methodName;
    private String methodSignature;
    private String path;
    private int lineNumber;
    private String nativeMethod;
    private String projectName;
    private String label = null;
    private String labelType = null;
    private HashMap<Object, List<PerformanceInfo>> performanceInfoMap = new HashMap();

    public SourceInfo() {
    }

    public SourceInfo(String string, String string2, String string3, String string4, String string5, String string6, int n2, String string7, String string8, String string9) {
        this.projectName = string;
        this.packageName = string2 == null ? "" : string2;
        this.className = string3;
        this.methodName = string4;
        this.methodSignature = string5;
        this.path = string6;
        this.lineNumber = n2;
        this.nativeMethod = string7;
        this.label = string8;
        this.labelType = string9;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String string) {
        this.className = string;
    }

    public String getNativeMethod() {
        return this.nativeMethod;
    }

    public void setNativeMethod(String string) {
        this.nativeMethod = string;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int n2) {
        this.lineNumber = n2;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String string) {
        this.methodName = string;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String string) {
        this.packageName = string == null ? "" : string;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String string) {
        this.projectName = string;
    }

    public String getMethodSignature() {
        return this.methodSignature;
    }

    public void setMethodSignature(String string) {
        this.methodSignature = string;
    }

    public String getFileExtension() {
        int n2;
        String string = null;
        if (this.path != null && (n2 = this.path.lastIndexOf(46)) >= 0 && n2 < this.path.length() - 1) {
            string = this.path.substring(n2 + 1);
        }
        return string;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SourceInfo)) {
            return false;
        }
        SourceInfo sourceInfo = (SourceInfo)object;
        if (!SourceInfo.compareString(this.className, sourceInfo.className)) {
            return false;
        }
        if (this.lineNumber != sourceInfo.lineNumber) {
            return false;
        }
        if (!SourceInfo.compareString(this.methodName, sourceInfo.methodName)) {
            return false;
        }
        if (!SourceInfo.compareString(this.methodSignature, sourceInfo.methodSignature)) {
            return false;
        }
        if (!SourceInfo.compareString(this.nativeMethod, sourceInfo.nativeMethod)) {
            return false;
        }
        if (!SourceInfo.compareString(this.packageName, sourceInfo.packageName)) {
            return false;
        }
        if (!SourceInfo.compareString(this.path, sourceInfo.path)) {
            return false;
        }
        return SourceInfo.compareString(this.projectName, sourceInfo.projectName);
    }

    private static boolean compareString(String string, String string2) {
        boolean bl2 = false;
        if (string == null && string2 == null) {
            bl2 = true;
        } else if (string != null && string2 != null) {
            bl2 = string.equals(string2);
        }
        return bl2;
    }

    public void addPerformanceInfo(Object object, PerformanceInfo performanceInfo) {
        List<PerformanceInfo> list = this.performanceInfoMap.get(object);
        if (list == null) {
            list = new ArrayList<PerformanceInfo>();
            this.performanceInfoMap.put(object, list);
        }
        list.add(performanceInfo);
    }

    public List<PerformanceInfo> getPerformanceInfo() {
        ArrayList<PerformanceInfo> arrayList = null;
        Collection<List<PerformanceInfo>> collection = this.performanceInfoMap.values();
        if (collection.size() > 0) {
            arrayList = new ArrayList<PerformanceInfo>();
            for (List<PerformanceInfo> list : collection) {
                arrayList.addAll(list);
            }
        }
        return arrayList;
    }

    public Map<Object, List<PerformanceInfo>> getPerformanceInfoByRunId() {
        return this.performanceInfoMap;
    }

    public void changeRunId(Object object, Object object2) {
        List<PerformanceInfo> list = this.performanceInfoMap.remove(object);
        if (list != null) {
            this.performanceInfoMap.put(object2, list);
        }
    }

    public void addPerformanceInfoFrom(SourceInfo sourceInfo) {
        this.addPerformanceInfoFrom(sourceInfo.performanceInfoMap);
    }

    public void addPerformanceInfoFrom(Map<Object, List<PerformanceInfo>> map) {
        for (Map.Entry<Object, List<PerformanceInfo>> entry : map.entrySet()) {
            Object object = entry.getKey();
            List<PerformanceInfo> list = entry.getValue();
            for (PerformanceInfo performanceInfo : list) {
                this.addPerformanceInfo(object, performanceInfo);
            }
        }
    }

    public void removePerformanceInfoFor(Object object) {
        this.performanceInfoMap.remove(object);
    }

    public Object clone() throws CloneNotSupportedException {
        SourceInfo sourceInfo = (SourceInfo)super.clone();
        sourceInfo.packageName = this.packageName;
        sourceInfo.className = this.className;
        sourceInfo.methodName = this.methodName;
        sourceInfo.methodSignature = this.methodSignature;
        sourceInfo.path = this.path;
        sourceInfo.lineNumber = this.lineNumber;
        sourceInfo.nativeMethod = this.nativeMethod;
        sourceInfo.projectName = this.projectName;
        sourceInfo.performanceInfoMap = (HashMap)this.performanceInfoMap.clone();
        sourceInfo.label = this.label;
        sourceInfo.labelType = this.labelType;
        return sourceInfo;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getLabelType() {
        return this.labelType;
    }

    public void setLabelType(String string) {
        this.labelType = string;
    }
}

