/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.object;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

final class UnsafeAccess {
    private static final Unsafe UNSAFE = UnsafeAccess.getUnsafe();
    static final long ARRAY_INT_BASE_OFFSET = UNSAFE.arrayBaseOffset(int[].class);
    static final long ARRAY_INT_INDEX_SCALE = UNSAFE.arrayIndexScale(int[].class);
    static final Object ANY_LOCATION = new Object();
    private static final int MAX_UNROLL = 32;
    private static final boolean USE_ARRAYCOPY = true;

    private UnsafeAccess() {
    }

    static long objectFieldOffset(Field field) {
        return UNSAFE.objectFieldOffset(field);
    }

    static Object unsafeGetObject(Object receiver, long offset) {
        return UNSAFE.getObject(receiver, offset);
    }

    static void unsafePutObject(Object receiver, long offset, Object value) {
        UNSAFE.putObject(receiver, offset, value);
    }

    static long unsafeGetLong(Object receiver, long offset) {
        return UNSAFE.getLong(receiver, offset);
    }

    static void unsafePutLong(Object receiver, long offset, long value) {
        UNSAFE.putLong(receiver, offset, value);
    }

    static int intCast(boolean value) {
        return value ? 1 : 0;
    }

    static boolean booleanCast(int value) {
        return value != 0;
    }

    static <T> T unsafeCast(Object value, Class<T> type, boolean condition, boolean nonNull, boolean exact) {
        return (T)value;
    }

    static <T> T unsafeCast(Object value, Class<T> type, boolean condition, boolean nonNull) {
        return UnsafeAccess.unsafeCast(value, type, condition, nonNull, false);
    }

    static void arraycopy(Object from, int fromIndex, Object to, int toIndex, int length) {
        System.arraycopy(from, fromIndex, to, toIndex, length);
    }

    static boolean unsafeGetBoolean(Object receiver, long offset, boolean condition, Object locationIdentity) {
        assert (receiver != null);
        return UNSAFE.getBoolean(receiver, offset);
    }

    static byte unsafeGetByte(Object receiver, long offset, boolean condition, Object locationIdentity) {
        assert (receiver != null);
        return UNSAFE.getByte(receiver, offset);
    }

    static short unsafeGetShort(Object receiver, long offset, boolean condition, Object locationIdentity) {
        assert (receiver != null);
        return UNSAFE.getShort(receiver, offset);
    }

    static int unsafeGetInt(Object receiver, long offset, boolean condition, Object locationIdentity) {
        assert (receiver != null);
        return UNSAFE.getInt(receiver, offset);
    }

    static long unsafeGetLong(Object receiver, long offset, boolean condition, Object locationIdentity) {
        assert (receiver != null);
        return UNSAFE.getLong(receiver, offset);
    }

    static float unsafeGetFloat(Object receiver, long offset, boolean condition, Object locationIdentity) {
        assert (receiver != null);
        return UNSAFE.getFloat(receiver, offset);
    }

    static double unsafeGetDouble(Object receiver, long offset, boolean condition, Object locationIdentity) {
        assert (receiver != null);
        return UNSAFE.getDouble(receiver, offset);
    }

    static Object unsafeGetObject(Object receiver, long offset, boolean condition, Object locationIdentity) {
        assert (receiver != null);
        return UNSAFE.getObject(receiver, offset);
    }

    static void unsafePutBoolean(Object receiver, long offset, boolean value, Object locationIdentity) {
        assert (receiver != null);
        UNSAFE.putBoolean(receiver, offset, value);
    }

    static void unsafePutByte(Object receiver, long offset, byte value, Object locationIdentity) {
        assert (receiver != null);
        UNSAFE.putByte(receiver, offset, value);
    }

    static void unsafePutShort(Object receiver, long offset, short value, Object locationIdentity) {
        assert (receiver != null);
        UNSAFE.putShort(receiver, offset, value);
    }

    static void unsafePutInt(Object receiver, long offset, int value, Object locationIdentity) {
        assert (receiver != null);
        UNSAFE.putInt(receiver, offset, value);
    }

    static void unsafePutLong(Object receiver, long offset, long value, Object locationIdentity) {
        assert (receiver != null);
        UNSAFE.putLong(receiver, offset, value);
    }

    static void unsafePutFloat(Object receiver, long offset, float value, Object locationIdentity) {
        assert (receiver != null);
        UNSAFE.putFloat(receiver, offset, value);
    }

    static void unsafePutDouble(Object receiver, long offset, double value, Object locationIdentity) {
        assert (receiver != null);
        UNSAFE.putDouble(receiver, offset, value);
    }

    static void unsafePutObject(Object receiver, long offset, Object value, Object locationIdentity) {
        assert (receiver != null);
        UNSAFE.putObject(receiver, offset, value);
    }

    static int unsafeGetFinalInt(Object receiver, long offset, boolean condition, Object locationIdentity) {
        return UnsafeAccess.unsafeGetInt(receiver, offset, condition, locationIdentity);
    }

    static long unsafeGetFinalLong(Object receiver, long offset, boolean condition, Object locationIdentity) {
        return UnsafeAccess.unsafeGetLong(receiver, offset, condition, locationIdentity);
    }

    static double unsafeGetFinalDouble(Object receiver, long offset, boolean condition, Object locationIdentity) {
        return UnsafeAccess.unsafeGetDouble(receiver, offset, condition, locationIdentity);
    }

    static Object unsafeGetFinalObject(Object receiver, long offset, boolean condition, Object locationIdentity) {
        return UnsafeAccess.unsafeGetObject(receiver, offset, condition, locationIdentity);
    }

    static void arrayCopy(Object[] from, Object[] to, int length) {
        if (CompilerDirectives.isPartialEvaluationConstant(length) && length <= 32) {
            UnsafeAccess.arrayCopyUnroll(from, to, length);
        } else {
            UnsafeAccess.arraycopy(from, 0, to, 0, length);
        }
    }

    @ExplodeLoop
    private static void arrayCopyUnroll(Object[] from, Object[] to, int length) {
        for (int i = 0; i < length; ++i) {
            Object value = UnsafeAccess.unsafeGetObject(from, (long)Unsafe.ARRAY_OBJECT_BASE_OFFSET + (long)i * (long)Unsafe.ARRAY_OBJECT_INDEX_SCALE, false, null);
            UnsafeAccess.unsafePutObject(to, (long)Unsafe.ARRAY_OBJECT_BASE_OFFSET + (long)i * (long)Unsafe.ARRAY_OBJECT_INDEX_SCALE, value, ANY_LOCATION);
        }
    }

    private static void arrayCopyLoop(Object[] from, Object[] to, int length) {
        for (int i = 0; i < length; ++i) {
            Object value = UnsafeAccess.unsafeGetObject(from, (long)Unsafe.ARRAY_OBJECT_BASE_OFFSET + (long)i * (long)Unsafe.ARRAY_OBJECT_INDEX_SCALE, false, null);
            UnsafeAccess.unsafePutObject(to, (long)Unsafe.ARRAY_OBJECT_BASE_OFFSET + (long)i * (long)Unsafe.ARRAY_OBJECT_INDEX_SCALE, value, ANY_LOCATION);
        }
    }

    static void arrayCopy(int[] from, int[] to, int length) {
        if (CompilerDirectives.isPartialEvaluationConstant(length) && length <= 32) {
            UnsafeAccess.arrayCopyUnroll(from, to, length);
        } else {
            UnsafeAccess.arraycopy(from, 0, to, 0, length);
        }
    }

    @ExplodeLoop
    private static void arrayCopyUnroll(int[] from, int[] to, int length) {
        for (int i = 0; i < length; ++i) {
            int value = UnsafeAccess.unsafeGetInt(from, (long)Unsafe.ARRAY_INT_BASE_OFFSET + (long)i * (long)Unsafe.ARRAY_INT_INDEX_SCALE, false, null);
            UnsafeAccess.unsafePutInt(to, (long)Unsafe.ARRAY_INT_BASE_OFFSET + (long)i * (long)Unsafe.ARRAY_INT_INDEX_SCALE, value, ANY_LOCATION);
        }
    }

    private static void arrayCopyLoop(int[] from, int[] to, int length) {
        for (int i = 0; i < length; ++i) {
            int value = UnsafeAccess.unsafeGetInt(from, (long)Unsafe.ARRAY_INT_BASE_OFFSET + (long)i * (long)Unsafe.ARRAY_INT_INDEX_SCALE, false, null);
            UnsafeAccess.unsafePutInt(to, (long)Unsafe.ARRAY_INT_BASE_OFFSET + (long)i * (long)Unsafe.ARRAY_INT_INDEX_SCALE, value, ANY_LOCATION);
        }
    }

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException securityException) {
            try {
                Field theUnsafeInstance = Unsafe.class.getDeclaredField("theUnsafe");
                theUnsafeInstance.setAccessible(true);
                return (Unsafe)theUnsafeInstance.get(Unsafe.class);
            }
            catch (Exception e) {
                throw new RuntimeException("exception while trying to get Unsafe.theUnsafe via reflection:", e);
            }
        }
    }
}

