/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.function.builtins.clinic;

import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentCastNode;

public abstract class ArgumentClinicProvider {
    public static final ArgumentClinicProvider NOOP = new NoopArgumentClinic();
    private final int acceptsBoolean;
    private final int acceptsInt;
    private final int acceptsLong;
    private final int acceptsDouble;
    private final int hasCastNode;

    public ArgumentClinicProvider(int acceptsBoolean, int acceptsInt, int acceptsLong, int acceptsDouble, int hasCastNode) {
        this.acceptsBoolean = acceptsBoolean;
        this.acceptsInt = acceptsInt;
        this.acceptsLong = acceptsLong;
        this.acceptsDouble = acceptsDouble;
        this.hasCastNode = hasCastNode;
    }

    public final boolean acceptsBoolean(int argIndex) {
        return (this.acceptsBoolean & 1 << argIndex) != 0;
    }

    public final boolean acceptsInt(int argIndex) {
        return (this.acceptsInt & 1 << argIndex) != 0;
    }

    public final boolean acceptsLong(int argIndex) {
        return (this.acceptsLong & 1 << argIndex) != 0;
    }

    public final boolean acceptsDouble(int argIndex) {
        return (this.acceptsDouble & 1 << argIndex) != 0;
    }

    public final boolean hasCastNode(int argIndex) {
        return (this.hasCastNode & 1 << argIndex) != 0;
    }

    public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
        throw new IllegalStateException("createCastNode should not be called unless hasCastNode returns true");
    }

    private static final class NoopArgumentClinic
    extends ArgumentClinicProvider {
        NoopArgumentClinic() {
            super(-1, -1, -1, -1, 0);
        }
    }
}

