/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4CCallableStatement;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CInputStream;
import oracle.jdbc.driver.T4CPreparedStatement;
import oracle.jdbc.driver.T4CStatement;
import oracle.jdbc.internal.AbstractConnectionBuilder;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleCallableStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OraclePreparedStatement;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CDriverExtension
extends OracleDriverExtension
implements Monitor {
    private OracleDriverExtension shardingDriverExtension;
    private static String shardingDriverExtensionClassName;
    private static final Monitor DEFAULT_CONN_MONITOR;
    private final Monitor.CloseableLock monitorLock;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;

    T4CDriverExtension() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$8, null, new Object[0]);
            }
            this.shardingDriverExtension = null;
            this.monitorLock = this.newDefaultLock();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$8, null);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$8, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$8, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @DefaultLevel(value=Logging.FINEST)
    final Connection getConnection(String string, @Blind(value=PropertiesBlinder.class) Properties properties, AbstractConnectionBuilder<?, ?> abstractConnectionBuilder) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            T4CConnection t4CConnection;
            block28: {
                void builder;
                void info;
                void url;
                T4CConnection conn;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$0, this, string, TraceControllerImpl.blind(PropertiesBlinder.class, properties), abstractConnectionBuilder);
                }
                if ((conn = new T4CConnection((String)url, (Properties)info, this)).useShardingDriverConnection() && !conn.isShardingDriverMode()) {
                    block26: {
                        if (this.shardingDriverExtension == null) {
                            try {
                                Monitor.CloseableLock lock;
                                block27: {
                                    lock = this.acquireCloseableLock();
                                    Throwable throwable = null;
                                    try {
                                        if (this.shardingDriverExtension == null) {
                                            this.shardingDriverExtension = (OracleDriverExtension)Class.forName(shardingDriverExtensionClassName).newInstance();
                                        }
                                        if (lock == null) break block26;
                                        if (throwable == null) break block27;
                                    }
                                    catch (Throwable throwable3) {
                                        try {
                                            throwable = throwable3;
                                            Throwable throwable4 = throwable3;
                                            if (bl) {
                                                ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$0, this, throwable4);
                                            }
                                            throw throwable4;
                                        }
                                        catch (Throwable throwable5) {
                                            if (lock != null) {
                                                if (throwable != null) {
                                                    try {
                                                        lock.close();
                                                    }
                                                    catch (Throwable throwable6) {
                                                        throwable.addSuppressed(throwable6);
                                                    }
                                                } else {
                                                    lock.close();
                                                }
                                            }
                                            Throwable throwable7 = throwable5;
                                            if (bl) {
                                                ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$0, this, throwable7);
                                            }
                                            throw throwable7;
                                        }
                                    }
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    break block26;
                                }
                                lock.close();
                            }
                            catch (Exception lock) {
                                // empty catch block
                            }
                        }
                    }
                    Connection connection = this.shardingDriverExtension.getConnection((String)url, (Properties)info, (AbstractConnectionBuilder<?, ?>)builder);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$0, this, connection);
                        ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$0, this, null);
                    }
                    return connection;
                }
                try {
                    conn.connect((AbstractConnectionBuilder<?, ?>)builder);
                    t4CConnection = conn;
                    if (!bl) break block28;
                }
                catch (Exception e2) {
                    Exception exception = e2;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$0, this, exception);
                    }
                    throw exception;
                }
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$0, this, t4CConnection);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$0, this, null);
            }
            return t4CConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$0, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final CompletionStage<Connection> getConnectionAsync(String string, @Blind(value=PropertiesBlinder.class) Properties properties, AbstractConnectionBuilder<?, ?> abstractConnectionBuilder) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            CompletionStage<Connection> completionStage;
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$1, this, string, TraceControllerImpl.blind(PropertiesBlinder.class, properties), abstractConnectionBuilder);
                }
                try {
                    void builder;
                    void info;
                    void url;
                    T4CConnection conn = new T4CConnection((String)url, (Properties)info, this);
                    completionStage = conn.connectAsync((AbstractConnectionBuilder<?, ?>)builder).thenApply(void_ -> {
                        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
                        try {
                            T4CConnection conn;
                            if (bl) {
                                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$7, null, conn, void_);
                            }
                            T4CConnection t4CConnection2 = conn;
                            if (bl) {
                                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$7, null, t4CConnection2);
                                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$7, null, null);
                            }
                            return t4CConnection2;
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            if (bl) {
                                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$7, null, throwable2);
                            }
                            throw throwable;
                        }
                    });
                    if (!bl) break block7;
                }
                catch (SQLException preConnectFailure) {
                    CompletionStage<Connection> completionStage2 = CompletionStageUtil.failedStage(preConnectFailure);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$1, this, completionStage2);
                        ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$1, this, null);
                    }
                    return completionStage2;
                }
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$1, this, completionStage);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$1, this, null);
            }
            return completionStage;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    oracle.jdbc.internal.OracleStatement allocateStatement(OracleConnection oracleConnection, @Blind(value=PropertiesBlinder.class) Properties properties) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void stmtProps;
            void conn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$2, this, oracleConnection, TraceControllerImpl.blind(PropertiesBlinder.class, properties));
            }
            T4CStatement t4CStatement = new T4CStatement((PhysicalConnection)conn, (Properties)stmtProps);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$2, this, t4CStatement);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$2, this, null);
            }
            return t4CStatement;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    OraclePreparedStatement allocatePreparedStatement(OracleConnection oracleConnection, String string, @Blind(value=PropertiesBlinder.class) Properties properties) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void stmtProps;
            void sql;
            void conn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$3, this, oracleConnection, string, TraceControllerImpl.blind(PropertiesBlinder.class, properties));
            }
            T4CPreparedStatement t4CPreparedStatement = new T4CPreparedStatement((PhysicalConnection)conn, (String)sql, (Properties)stmtProps);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$3, this, t4CPreparedStatement);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$3, this, null);
            }
            return t4CPreparedStatement;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    OracleCallableStatement allocateCallableStatement(OracleConnection oracleConnection, String string, @Blind(value=PropertiesBlinder.class) Properties properties) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void stmtProps;
            void sql;
            void conn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$4, this, oracleConnection, string, TraceControllerImpl.blind(PropertiesBlinder.class, properties));
            }
            T4CCallableStatement t4CCallableStatement = new T4CCallableStatement((PhysicalConnection)conn, (String)sql, (Properties)stmtProps);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$4, this, t4CCallableStatement);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$4, this, null);
            }
            return t4CCallableStatement;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    OracleInputStream createInputStream(OracleStatement oracleStatement, int n2, Accessor accessor) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void accessor2;
            void index;
            void stmt;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$5, this, oracleStatement, n2, accessor);
            }
            T4CInputStream t4CInputStream = new T4CInputStream((OracleStatement)stmt, (int)index, (Accessor)accessor2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$5, this, t4CInputStream);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$5, this, null);
            }
            return t4CInputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$6, this, new Object[0]);
            }
            Monitor.CloseableLock closeableLock = this.monitorLock;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$6, this, closeableLock);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$6, this, null);
            }
            return closeableLock;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4CDriverExtension.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$8 = T4CDriverExtension.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = T4CDriverExtension.class.getDeclaredMethod("lambda$getConnectionAsync$0", T4CConnection.class, Void.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = T4CDriverExtension.class.getDeclaredMethod("getMonitorLock", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T4CDriverExtension.class.getDeclaredMethod("createInputStream", OracleStatement.class, Integer.TYPE, Accessor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4CDriverExtension.class.getDeclaredMethod("allocateCallableStatement", OracleConnection.class, String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4CDriverExtension.class.getDeclaredMethod("allocatePreparedStatement", OracleConnection.class, String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4CDriverExtension.class.getDeclaredMethod("allocateStatement", OracleConnection.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CDriverExtension.class.getDeclaredMethod("getConnectionAsync", String.class, Properties.class, AbstractConnectionBuilder.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CDriverExtension.class.getDeclaredMethod("getConnection", String.class, Properties.class, AbstractConnectionBuilder.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        shardingDriverExtensionClassName = "oracle.jdbc.driver.ShardingDriverExtension";
        DEFAULT_CONN_MONITOR = Monitor.newInstance();
    }
}

